<?php
error_reporting(0);
ob_start();
include_once "config.php";
$load = sys_getloadavg();
#  ------------------------------------------------------------
$telegram_ip_ranges = [
    ['lower' => '149.154.160.0', 'upper' => '149.154.175.255'],
    ['lower' => '91.108.4.0',    'upper' => '91.108.7.255'],
];
$ip_dec = (float) sprintf("%u", ip2long($_SERVER['REMOTE_ADDR']));
$ok = false;
foreach ($telegram_ip_ranges as $telegram_ip_range) if (!$ok) {
    $lower_dec = (float) sprintf("%u", ip2long($telegram_ip_range['lower']));
    $upper_dec = (float) sprintf("%u", ip2long($telegram_ip_range['upper']));
    if ($ip_dec >= $lower_dec and $ip_dec <= $upper_dec) $ok = true;
}
if (!$ok) die("Are you missing ¿");
#  ------------------------------------------------------------
$db = mysqli_connect('localhost', $databaseUser, $databasePass, $databaseName);
date_default_timezone_set('Asia/Tehran');
$date = date('Y/m/d | H:i:s');
$time = time();
# functions -----------------------------------------------
function Blacksource($method, $datas = [])
{
    $url = "https://api.telegram.org/bot" . API_TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        var_dump(curl_error($ch));
    } else {
        return json_decode($res);
    }
}
#  ------------------------------------------------------------
function sendMessage($chat_id, $text, $parse_mode = '', $keyboard = '', $message_id = '')
{
    return Blacksource('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => $parse_mode,
        'disable_web_page_preview' => true,
        'reply_markup' => $keyboard,
        'reply_to_message_id' => $message_id
    ]);
}
#  ------------------------------------------------------------
function editMessageText($chat_id, $message_id, $text, $parse_mode = null, $keyboard = null)
{
    Blacksource('editMessageText', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => $parse_mode,
        'reply_markup' => $keyboard,
        'disable_web_page_preview' => true,

    ]);
}
#  ------------------------------------------------------------
function deleteMessage($chat_id, $message_id)
{
    Blacksource('deleteMessage', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
    ]);
}
#  ------------------------------------------------------------
function ForwardMessage($KojaShe, $AzKoja, $KodomMSG)
{
    Blacksource('ForwardMessage', [
        'chat_id' => $KojaShe,
        'from_chat_id' => $AzKoja,
        'message_id' => $KodomMSG,
    ]);
}
function answercallbackquery($callback_query_id, $text, $show_alert = true)
{
    Blacksource('answercallbackquery', [
        'callback_query_id' => $callback_query_id,
        'text' => $text,
        'show_alert' => $show_alert
    ]);
}
#  ------------------------------------------------------------
function getChatMember($chat_id, $user_id)
{
    return Blacksource('getChatMember', [
        'chat_id' => $chat_id,
        'user_id' => $user_id
    ]);
}
#  ------------------------------------------------------------
function exportChatInviteLink($chat_id)
{
    return Blacksource('exportChatInviteLink', [
        'chat_id' => $chat_id,
    ])->result;
}
#  ------------------------------------------------------------
function getChat($chat_id)
{
    $result = Blacksource('getChat', [
        'chat_id' => $chat_id,
    ]);
    $invite_link = $result->result->invite_link ?: exportChatInviteLink($chat_id);
    $result->result->invite_link = $invite_link;
    return $result;
}
#  ------------------------------------------------------------
function getUserProfilePhotos($from_id)
{
    return Blacksource("getUserProfilePhotos", [
        'user_id' => $from_id
    ])->result;
}
#  ------------------------------------------------------------
function isJoin($from_id)
{

    global $db;
    $lockSQL = mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` != 'false' LIMIT 3");
    if (mysqli_num_rows($lockSQL) >= 1) {
        while ($id = mysqli_fetch_assoc($lockSQL)) {
            $status = getChatMember($id['type_id'], $from_id)->result->status;
            $result[] = $status;
        }
        if (in_array("left", $result)) {
            return false;
        } else {
            return true;
        }
    } else {
        return true;
    }
}
#  ------------------------------------------------------------
function joinSend($from_id, $file = null)
{
    global $db;
    $lockSQL = mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` != 'false'");
    $i = 0;
    while ($id = mysqli_fetch_assoc($lockSQL)) {
        $key = str_replace(['1', '2', '3', '4', '5', '6', '7', '8', '9', '0'], ['اول', 'دوم', 'سوم', 'چهارم', 'پنجم', 'ششم', 'هفتم', 'هشتم', 'نهم', 'دهم'], $i + 1);
        $chat = getChat($id['type_id']);
        $invite_link = $id['columnTwo'] ?: $chat->result->invite_link;
        if (Blacksource('getChatMember', ['chat_id' => $id['type_id'], 'user_id' => $from_id])->result->status == 'left') {
            $button[] = [['text' => "عضویت در کانال $key", 'url' => "$invite_link"]];
        } else $i--;
        $i++;
    }
    $button[] = [['text' => "عضو شدم | دانلود ✅", 'callback_data' => "join_" . $file]];
    $buttons = json_encode(['inline_keyboard' => $button]);
    sendMessage($from_id, "❓ برای استفاده از ربات و اپلود و دریافت فایل عضو کانال های ما شوید.\n\n💡 پس عضویت بر روی « عضو شدم » کلیک کنید", "html", $buttons);
}
#  ------------------------------------------------------------
function random($max = 10)
{
    $textChar = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789';
    $textRandom = '';
    for ($i = 0; $i <= $max; $i++) {
        $textRandom .= $textChar[rand(0, strlen($textChar))];
    }
    return $textRandom;
}
#  ------------------------------------------------------------
function convert($size)
{
    return round($size / pow(1024, ($i = floor(log($size, 1024)))), 2) . ' ' . ['', 'K', 'M', 'G', 'T', 'P'][$i] . 'B';
}
#  ------------------------------------------------------------
function doc($name)
{
    switch ($name) {
        case 'document':
            return "پرونده ( سند )";
            break;
        case 'video':
            return "ویدیو";
            break;
        case 'photo':
            return "عکس";
            break;
        case 'voice':
            return "ویس";
            break;
        case 'audio':
            return "موزیک";
            break;
        case 'sticker':
            return "استیکر";
            break;
        default:
            return "ناشناس ...";
            break;
    }
}
function send($user_id, $message_id, $id, $status)
{
    global $db, $usernamebot, $text, $btn_back, $first_name, $btn_home;
    $fileData = mysqli_query($db, "SELECT * FROM `file` WHERE `id` = '{$id}'");
    if (mysqli_num_rows($fileData)) {
        $file = mysqli_fetch_assoc($fileData);
        if ($file['password'] and $status == 'send') {
            sendMessage($user_id, "▪️ لطفا رمز فایل را ارسال کنید تا فایل برای شما ارسال شود :", "markdown", $btn_back, $message_id);
            mysqli_query($db, "UPDATE `user` SET `step` = 'password', `getFile` = '$id' WHERE `from_id` = '$user_id'");
            exit(false);
        } else {
            $linkSeenSQL = $db->query("SELECT * FROM `settings` WHERE `type` = 'linkSeen'");
            if (mysqli_num_rows($linkSeenSQL) and $status != 'seen') {
                $linkSeen = mysqli_fetch_assoc($linkSeenSQL);
                $seenTime = time() + 10; // این عدد مقدار به خواب رفتن ربات برای سین زدن پست هاست
                sendMessage($user_id, "▪️ لطفا برای دریافت فایل به کانال زیر رفته و 10 پست اخر آن را مشاهده و سپس دکمه (✅مشاهده کردم) را بزنید :\n{$linkSeen['columnOne']}\n\n⚠️ توجه کنید که سین پست ها باید به ارامی باشد تا ربات سین شما را دریافت کند.", null, json_encode(['inline_keyboard' => [[['text' => '✅مشاهده کردم', 'callback_data' => 'linkSeen_' . $id . '_' . $seenTime]]]]));
            } else {
                if ($status == 'seen') deleteMessage($user_id, $message_id);
                $fileData = mysqli_query($db, "SELECT * FROM `file` WHERE `id` = '{$id}'");
                $file = mysqli_fetch_assoc($fileData);
                if (in_array($status, ['seen', 'send']) or ($text == urldecode($file['password']) and $status == 'pass')) {
                    $fileData = mysqli_query($db, "SELECT * FROM `file` WHERE `id` = '{$id}'");
                    $sleep = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'del'"))['type_id'] * 60;
                    while ($file = mysqli_fetch_assoc($fileData)) {
                        $downloads = number_format($file['downloads'] + 1);
                        $caption = urldecode($file['caption']);
                        $msgId = Blacksource("send{$file['type']}", [
                            'chat_id' => $user_id,
                            $file['type'] => $file['file_id'],
                            'caption' => "📥 تعداد دانلود ها : <code>{$downloads}</code>\n{$caption}\n🤖 @$usernamebot",
                            'parse_mode' => "html",
                        ])->result->message_id;
                        $timeDel = time() + $sleep;
                        $db->query("INSERT INTO `del` (`id`, `user_id`, `message_id`, `timeDel`) VALUES ('$id', '$user_id', '$msgId', '$timeDel')");
                    }
                    mysqli_query($db, "UPDATE `file` SET `downloads` = `downloads`+1 WHERE `id` = '$id'");
                    mysqli_query($db, "UPDATE `user` SET `step` = 'none', `downloads` = `downloads`+1 WHERE `from_id` = '$user_id'");
                    if ($sleep > 0) sendMessage($user_id, "⚠️ توجه کنید که بعد از $sleep ثانیه حذف خواهد شد\nلطفا پیام(های) ارسالی را به پیوی خود بفرستید و انجا مشاهده کنید");
                    $ads = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'ads'"));
                    if ($ads['type_id'] != 'text') Blacksource("send{$ads['type_id']}", ['chat_id' => $user_id, $ads['type_id'] => $ads['columnOne'], 'caption' => urldecode($ads['columnTwo']), 'parse_mode' => "html"]);
                    else sendMessage($user_id, urldecode($ads['columnTwo']), 'html');
                } else {
                    sendMessage($user_id, "▪️ پسورد اشتباه است , لطفا پسورد صحیح را ارسال کنید :\n🔸 در صورت نیاز به منوی اصلی روی /start کلیک کنید ... !", "markdown", $btn_back, $message_id);
                    exit(false);
                }
            }
        }
    } else sendMessage($user_id, "👤 سلام $first_name\n🤖 به ربات آپلودک خوش امدید!\n\n🏷 اپلود رایگان و دائم فایل ها بدون هیچ محدودیت زمانی !\n\n🚦 شما میتوانید ( عکس , فیلم , گیف , استیکر و ... ) در ربات اپلود کنید همراه با نمایش تعداد دانلود های فایل شما ... !\n\n▪️ شما میتوانید تا سقف یک گیگابایت (2GB) فایل اپلود کنید و لینک فایل خودتون رو دریافت کنید و برای دوستان خود ارسال کنید :\n\n🔐 دقت کنید که میتوانید برای لینک فایل های خودتون رمز بگزارید تا هرکسی نتواند فایلتون رو دانلود کنه , برای دسترسی به فایل وقتی که کاربر با لینک دانلود وارد میشود ربات از او رمز رو درخواست میکند در صورت صحیح بودن رمزی که شما برای فایلتون انتخاب کردید فایل برایش ارسال میشود ... !\n\n📤 همین الان یه فایل بفرس تا آپلود بشه و لذتشو ببر !\n\n🤖 @$usernamebot", null, $btn_home, $message_id);
}
# Update ------------------------------------------------------------
$update = json_decode(file_get_contents('php://input'));
$message = $update->message;
$chat_id = $update->message->chat->id ?: $update->callback_query->message->chat->id;
$from_id = $update->message->from->id ?: $update->callback_query->from->id;
$text = $update->message->text ?: $update->channel_post->text;
$first_name = $update->message->from->first_name ?: $update->callback_query->from->first_name;
$last_name = $update->message->from->last_name ?: $update->callback_query->from->last_name;
$username = $update->message->from->username ?: $update->callback_query->from->username;
$type = $update->message->chat->type ?: $update->callback_query->message->chat->type ?: $update->channel_post->chat->type;
$message_id = $update->message->message_id ?: $update->callback_query->message->message_id;

$data = $update->callback_query->data;
$callback_query_text = $update->callback_query->message->text;

$channel_id = $update->channel_post->chat->id;
$channel_message_id = $update->channel_post->message_id;
$callback_query_id = $update->callback_query->id;
$forward_from_chat_id = $update->message->forward_from_chat->id;
$forward_from_chat_title = $update->message->forward_from_chat->title;
$forward_from_chat_type = $update->message->forward_from_chat->type;
$forward_from_chat_username = $update->message->forward_from_chat->username;

$profile = getUserProfilePhotos($from_id)->photos[0][0]->file_id;

$botInfo = Blacksource('getMe')->result;
$usernamebot = $botInfo->username;
$first_namebot = $botInfo->first_name;
# get date ------------------------------------------------------------
$db->query("SET NAMES 'utf8'");
$db->set_charset('utf8mb4');

$userSQL = mysqli_query($db, "SELECT * FROM `user` WHERE `from_id` = '$from_id' LIMIT 1");
$user = mysqli_fetch_assoc($userSQL);
$step = $user['step'];

$admin_sql = mysqli_query($db, "SELECT `type_id`,`columnOne` FROM `settings` WHERE `type` = 'admin' AND `type_id` = '$from_id' LIMIT 1");
$admins_sql = mysqli_query($db, "SELECT `type_id`,`columnOne` FROM `settings` WHERE `type` = 'admin'");
# B'uttonS ------------------------------------------------------------ 
switch ($from_id == $admin) {
    case 1:
        $btn_home = json_encode([
            'keyboard' => [
                [['text' => "📂 تاریخچه اپلود"], ['text' => "🎫 حساب کاربری"]],
                [['text' => "🔐 تنظیم پسورد"], ['text' => "🗑 حذف فایل"]],
                [['text' => "👤 مدیریت"], ['text' => "🗂 کد پیگیری فایل"]],
            ], 'resize_keyboard' => true
        ]);
        $panel = json_encode([
            'keyboard' => [
                [['text' => "👤 امار ربات"], ['text' => '🗑 تنظیم حذف شدن']],
                [['text' => "📣 تنظیم تبلیغ"], ['text' => "🗑 حذف تبلیغ"]],
                [['text' => "📝 تنظیم کپشن"], ['text' => "🗑 حذف کپشن"]],
                [['text' => "👁‍🗨 تنظیم کانال سین"], ['text' => "🗑 حذف کانال سین"]],
                [['text' => "📪 ارسال به همه"], ['text' => "📪 فوروارد به همه"]],
                [['text' => "🧑🏻‍💻 بخش ادمین ها"], ['text' => "🔒 بخش قفل ها"]],
                [['text' => "🔙"]]
            ], 'resize_keyboard' => true
        ]);
        $back_panel = json_encode([
            'keyboard' => [
                [['text' => "برگشت 🔙"]]
            ], 'resize_keyboard' => true
        ]);
        break;

    default:
        $btn_home = json_encode([
            'keyboard' => [
                [['text' => "📂 تاریخچه اپلود"], ['text' => "🎫 حساب کاربری"]],
                [['text' => "🔐 تنظیم پسورد"], ['text' => "🗑 حذف فایل"]],
                [['text' => "🗂 کد پیگیری فایل"]]
            ], 'resize_keyboard' => true
        ]);
        break;
}
# Back ------------------------------------------------------------
$btn_back = json_encode([
    'keyboard' => [
        [['text' => "🔙 بازگشت"]]
    ], 'resize_keyboard' => true
]);
#  ------------------------------------------------------------
$btn_end = json_encode([
    'keyboard' => [
        [['text' => "🗄 اتمام اپلود"]]
    ], 'resize_keyboard' => true
]);
#  ------------------------------------------------------------
$remove = json_encode([
    'remove_keyboard' => [], 'remove_keyboard' => true
]);
# Insert Into D'atabase ------------------------------------------------------------
if (mysqli_num_rows($userSQL) == 0 & $type == "private") mysqli_query($db, "INSERT INTO `user`(`from_id`, `step`, `downloads`, `getFile`, `status`, `update_at`, `create_at`) VALUES ('$from_id', 'none', '0', '', 'active', '$time', '$time')");
$db->query("UPDATE `user` SET `update_at` = '$time' WHERE `from_id` = '$from_id'");
# Start ------------------------------------------------------------
if (preg_match('/^\/start get_(.*)/', $text, $match) or preg_match('/^\/get_(.*)/', $text, $match)) {
    $id = $match[1];
    if (isJoin($from_id)) {
        send($from_id, $message_id, $id, 'send');
    } else joinSend($from_id, $id);
}
# StartS ------------------------------------------------------------
elseif ($text == '/start' or $text == "🔙") {
    sendMessage($from_id, "👤 سلام `$first_name`\n🤖 به ربات آپلودک خوش امدید!\n\n🏷 اپلود رایگان و دائم فایل ها بدون هیچ محدودیت زمانی !\n\n🚦 شما میتوانید ( عکس , فیلم , گیف , استیکر و ... ) در ربات اپلود کنید همراه با نمایش تعداد دانلود های فایل شما ... !\n\n▪️ شما میتوانید تا سقف یک گیگابایت (2GB) فایل اپلود کنید و لینک فایل خودتون رو دریافت کنید و برای دوستان خود ارسال کنید :\n\n🔐 دقت کنید که میتوانید برای لینک فایل های خودتون رمز بگزارید تا هرکسی نتواند فایلتون رو دانلود کنه , برای دسترسی به فایل وقتی که کاربر با لینک دانلود وارد میشود ربات از او رمز رو درخواست میکند در صورت صحیح بودن رمزی که شما برای فایلتون انتخاب کردید فایل برایش ارسال میشود ... !\n\n📤 همین الان یه فایل بفرس تا آپلود بشه و لذتشو ببر !\n\n🤖 @$usernamebot", null, $btn_home, $message_id);
    $db->query("UPDATE `user` SET `step` = 'none', `getFile` = '' WHERE `from_id` = '$from_id' LIMIT 1");
}
#  ------------------------------------------------------------
elseif ($text == '🔙 بازگشت') {
    sendMessage($from_id, "🌼 به منوی اصلی ربات برگشتیم \n\n🎉 برای استفاده از ربات از دکمه های زیر استفاده کنید", 'markdown', $btn_home, $message_id);
    $db->query("UPDATE `user` SET `step` = 'none', `getFile` = '' WHERE `from_id` = '$from_id' LIMIT 1");
    exit(false);
}
# P'aSsword  ------------------------------------------------------------
elseif ($step == 'password') {
    $id = $user['getFile'];
    if (isJoin($from_id)) {
        send($from_id, $message_id, $id, 'pass');
    } else joinSend($from_id, $id);
}
# S'een PosT ------------------------------------------------------------
elseif (preg_match('/^linkSeen_(.*)_(.*)/', $data, $match)) {
    if ($match[2] < time()) {
        send($from_id, $message_id, $match[1], 'seen');
        $db->query("UPDATE `user` SET `step` = 'none', `getFile` = '' WHERE `from_id` = '$from_id' LIMIT 1");
    } else answercallbackquery($callback_query_id, "❌ لطفا پست ها را به ارامی مشاهده کنید");
}
# D'elete File ------------------------------------------------------------
elseif ($text == "🗑 حذف فایل") {
    if (isJoin($from_id)) {
        sendMessage($from_id, "▪️لطفا شناسه فایل خود را ارسال کنید :\n📍 توجه کنید که بعد از فرستادن شناسه , فایل همان لحظه پاک میشود پس لطفا الکی شناسه فایلتون رو ارسال نکنید و فقط در صورت نیاز استفاده بکنید از این بخش ... !", 'markdown', $btn_back, $message_id);
        $db->query("UPDATE `user` SET `step` = 'remove' WHERE `from_id` = '$from_id' LIMIT 1");
    } else joinSend($from_id);
}
#  ------------------------------------------------------------
elseif ($step == 'remove') {
    if (isJoin($from_id)) {
        $query = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `file` WHERE `user_id` = '{$from_id}' AND `id` = '{$text}'"));
        if ($query) {
            sendMessage($from_id, "✔️ فایل با موفقیت حذف شد ... !", 'markdown', $btn_home, $message_id);
            $db->query("UPDATE `user` SET `downloads` = `downloads` - 1, `step` = 'none'  WHERE `from_id` = '{$from_id}' LIMIT 1");
            $db->query("DELETE FROM `file` WHERE `id` = '{$text}' and `user_id` = '{$from_id}'");
        } else sendMessage($from_id, "▪️ خطا , این فایل در دیتابیس موجود نمیباشد یا فایل مال شخص دیگری میباشد و  شما اجازه دسترسی به این فایل را ندارید ... !", 'markdown', null, $message_id);
    } else joinSend($from_id);
}
# c-hek File ------------------------------------------------------------
elseif ($text == "🗂 کد پیگیری فایل") {
    if (isJoin($from_id)) {
        sendMessage($from_id, "▪️لطفا شناسه فایل خود را ارسال کنید :", 'markdown', $btn_back, $message_id);
        $db->query("UPDATE `user` SET `step` = 'checkfile' WHERE `from_id` = '{$from_id}' LIMIT 1");
    } else joinSend($from_id);
}
#  ------------------------------------------------------------
elseif ($step == "checkfile") {
    if (isJoin($from_id)) {
        $queryE = mysqli_query($db, "SELECT * FROM `file` WHERE `user_id` = '{$from_id}' AND `id` = '{$text}'");
        $query = mysqli_fetch_assoc($queryE);
        if ($query) {
            $file_size = convert($query['file_size']);
            $file = doc($query['type']);
            $time = $query['time'];
            $date = $query['date'];
            $caption = urldecode($query['caption']) ?: 'توضیحاتی وجود ندارد ... !';
            $password = urldecode($query['password']) ?: 'این فایل بدون رمز عبور است ... !';
            $count = mysqli_num_rows($queryE);
            if ($count = 1) sendMessage($from_id, "▪️ شناسه فایل شما : <code>$text</code>\n\n➖ بقیه اطلاعات فایل شما : \n\n💾  حجم فایل : <b>$file_size</b> \n▪️ نوع فایل : <b>$file</b>\n🔐 رمز فایل : <code>$password</code>\n📝 توضیحات فایل : \n<code>$caption</code>\n🕓 تاریخ و زمان اپلود : <b>" . $date . " - " . $time . "</b>" . "\nلینک شتراک گذاری فایل:\n\n📥 https://t.me/" . $usernamebot . "?start=_" . $query['id'] . "\n\n🤖 @$usernamebot", "html", $btn_home, $message_id);
            else sendMessage($from_id, "▪️ شناسه فایل های شما : <code>$text</code>\n\n➖ بقیه اطلاعات فایل های شما : \n\n🔐 رمز فایل : <code>$password</code>\n<code>$caption</code>\n🕓 تاریخ و زمان اپلود : <b>" . $date . " - " . $time . "</b>" . "\nلینک شتراک گذاری فایل:\n\n📥 https://t.me/" . $usernamebot . "?start=_" . $query['id'] . "\n\n🤖 @$usernamebot", "html", $btn_home, $message_id);
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '{$from_id}' LIMIT 1");
        } else sendMessage($from_id, "▪️ خطا , این فایل در دیتابیس موجود نمیباشد یا فایل مال شخص دیگری میباشد و  شما اجازه دسترسی به این فایل را ندارید ... !", "markdown", $btn_back, $message_id);
    } else joinSend($from_id);
}
# Account ------------------------------------------------------------
elseif ($text == "🎫 حساب کاربری") {
    if (isJoin($from_id)) {
        $files = mysqli_query($db, "SELECT * FROM `file` WHERE `user_id` = '$from_id'");
        $countFile = mysqli_num_rows($files) ?: 0;
        $btn_profile = json_encode(['inline_keyboard' => [
            [['text' => "📤 تعداد فایل اپلود شده", 'callback_data' => "countFile"], ['text' => $countFile, 'callback_data' => "countFile"]],
            [['text' => "📲 تعداد دانلود شده", 'callback_data' => "downloads"], ['text' => $user['downloads'], 'callback_data' => "downloads"]],
        ]]);
        if ($profile) {
            Blacksource('SendPhoto', [
                'chat_id' => $from_id,
                'photo' => $profile,
                'caption' => "💭 حساب کاربری شما در ربات ما :\n\n👤 نام کانت شما : <code>$first_name</code>\n🌟 یوزنیم اکانت شما : <code>$username</code>\n🆔 ایدی عددی شما : <code>$from_id</code>\n\n🤖 @$usernamebot",
                'reply_markup' => $btn_profile,
                'parse_mode' => "html",
                'reply_to_message_id' => $message_id
            ]);
        } else sendMessage($from_id, "💭 حساب کاربری شما در ربات ما :\n\n👤 نام کانت شما : <code>$first_name</code>\n🌟 یوزنیم اکانت شما : <code>$username</code>\n\n🤖 @$usernamebot", "html", $btn_profile, $message_id);
    } else joinSend($from_id);
}
# U-ploads ------------------------------------------------------------
elseif ($text == "📂 تاریخچه اپلود") {
    if (isJoin($from_id)) {
        $query = mysqli_query($db, "SELECT * FROM `file` WHERE `user_id` = {$from_id}");
        $count = mysqli_num_rows($query);
        if ($count > 0) {
            $result = "📂 تاریخچه اپلود های شما :\n📍 تعداد فایل های اپلود شده ی شما : $count\n➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖\n\n";
            $cnt = ($count >= 10) ? 10 : $count;
            for ($i = 1; $i <= $cnt; $i++) {
                $fetch = mysqli_fetch_assoc($query);
                $id = $fetch['id'];
                $file_size = convert($fetch['file_size']);
                $file = doc($fetch['type']);
                $time = $fetch['time'];
                $date = $fetch['date'];
                $password = urldecode($fetch['password']) ?: 'این فایل بدون رمز عبور است ... !';
                $result .= $i . ". 📥 /get_" . $id . PHP_EOL . "💾 " . $file_size . PHP_EOL . "▪️ نوع فایل : <b>$file</b>" . PHP_EOL . "🔐 رمز فایل : <code>$password</code>" . PHP_EOL . "🕓 تاریخ و زمان اپلود : <b>" . $date . " - " . $time . "</b>" . PHP_EOL . "➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖" . PHP_EOL;
            }
            if ($count > 10) sendMessage($from_id, $result, "html", json_encode(['inline_keyboard' => [[['text' => "▪️ صفحه ی بعدی", 'callback_data' => "Dnext_10"]]]]), $message_id);
            else sendMessage($from_id, $result, "html", null, $message_id);
        } else sendMessage($from_id, "▪️ تاریخچه اپلود شما خالی میباشد ... !", "html", null, $message_id);
    } else joinSend($from_id);
}
#  ------------------------------------------------------------
elseif (preg_match('/^Dnext_(.*)/', $data, $match)) {
    $last_id = $match[1];
    if (isJoin($from_id)) {
        $query = mysqli_query($db, "SELECT * FROM `file` WHERE `user_id` = '{$from_id}'");
        $count = mysqli_num_rows($query);
        $result = "📂 تاریخچه اپلود های شما :\n📍 تعداد فایل های اپلود شده ی شما : $count\n➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖\n\n";
        $records = [];
        while ($fetch = mysqli_fetch_assoc($query)) $records[] = $fetch;
        if ($last_id + 10 < $count) $endponit = $last_id + 10;
        else $endponit = $count;
        for ($row = $last_id; $row < $endponit; $row++) {
            $id = $records[$row]['id'];
            $file_size = convert($records[$row]['file_size']);
            $file = doc($records[$row]['type']);
            $time = $records[$row]['time'];
            $date = $records[$row]['date'];
            $password = $records[$row]['password'] ? $records[$row]['password'] : 'این فایل بدون رمز عبور است ... !';
            $result .= $row . ". 📥 /get_" . $id . PHP_EOL . "💾 " . $file_size . PHP_EOL . "▪️ نوع فایل : <b>$file</b>" . PHP_EOL . "🔐 رمز فایل : <code>$password</code>" . PHP_EOL . "🕓 تاریخ و زمان اپلود : <b>" . $date . " - " . $time . "</b>" . PHP_EOL . "➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖" . PHP_EOL;
        }
        if ($count > $last_id + 10) editMessageText($from_id, $message_id, $result, "html", json_encode(['inline_keyboard' => [[['text' => "➕ صفحه بعدی", 'callback_data' => "Dnext_" . $endponit], ['text' => "➖ صفحه ی قبلی", 'callback_data' => "Dprev_" . $endponit]]]]));
        else editMessageText($from_id, $message_id, $result, "html", json_encode(['inline_keyboard' => [[['text' => "➖ صفحه ی قبلی", 'callback_data' => "Dprev_" . $endponit]]]]));
    } else joinSend($from_id);
}
#  ------------------------------------------------------------
elseif (preg_match('/^Dprev_(.*)/', $data, $match)) {
    $last_id = $match[1];
    if (isJoin($from_id)) {
        $query = mysqli_query($db, "SELECT * FROM `file` WHERE `user_id` = '{$from_id}'");
        $count = mysqli_num_rows($query);
        $result = "📂 تاریخچه اپلود های شما :\n📍 تعداد فایل های اپلود شده ی شما : $count\n➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖\n\n";
        $records = [];
        while ($fetch = mysqli_fetch_assoc($query)) $records[] = $fetch;
        if ($last_id % 10 == 0) $endponit = $last_id - 10;
        else {
            $last_id = $last_id - ($last_id % 10);
            $endponit = $last_id;
        }
        for ($row = $endponit - 9; $row <= $endponit; $row++) {
            $id = $records[$row]['id'];
            $file_size = convert($records[$row]['file_size']);
            $file = doc($records[$row]['type']);
            $time = $records[$row]['time'];
            $date = $records[$row]['date'];
            $password = $records[$row]['password'] ? $records[$row]['password'] : 'این فایل بدون رمز عبور است ... !';
            $result .= $row + 1 . ". 📥 /get_" . $id . PHP_EOL . "💾 " . $file_size . PHP_EOL . "▪️ نوع فایل : <b>$file</b>" . PHP_EOL . "🔐 رمز فایل : <code>$password</code>" . PHP_EOL . "🕓 تاریخ و زمان اپلود : <b>" . $date . " - " . $time . "</b>" . PHP_EOL . "➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖ ➖" . PHP_EOL;
        }
        if ($count > $last_id and $endponit - 10 > 0) editMessageText($from_id, $message_id, $result, "html", json_encode(['inline_keyboard' => [[['text' => "➕ صفحه بعدی", 'callback_data' => "Dnext_" . $endponit], ['text' => "➖ صفحه ی قبلی", 'callback_data' => "Dprev_" . $endponit]]]]));
        else editMessageText($from_id, $message_id, $result, "html", json_encode(['inline_keyboard' => [[['text' => "➕ صفحه بعدی", 'callback_data' => "Dnext_" . $endponit]]]]));
    } else joinSend($from_id);
}
# set P'assword ------------------------------------------------------------
elseif ($text == "🔐 تنظیم پسورد") {
    if (isJoin($from_id)) {
        sendMessage($from_id, "▪️ لطفا شناسه فایل خود را ارسال کنید :", "markdown", $btn_back, $message_id);
        $db->query("UPDATE `user` SET `step` = 'sendid' WHERE `from_id` = '{$from_id}' LIMIT 1");
    } else joinSend($from_id);
}
#  ------------------------------------------------------------
elseif ($step == "sendid") {
    if (isJoin($from_id)) {
        $query = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `file` WHERE `user_id` = '{$from_id}' and `id` = '{$text}'"));
        if ($query) {
            sendMessage($from_id, "▪️لطفا پسورد دلخواه رو بفرستید تا فایل شما قفل شود :", "markdown", $btn_back, $message_id);
            $db->query("UPDATE `user` SET `step` = 'sendPassword', `getFile` = '$text' WHERE `from_id` = '{$from_id}' LIMIT 1");
        } else sendMessage($from_id, "▪️ خطا , این فایل در دیتابیس موجود نمیباشد یا فایل مال شخص دیگری میباشد و  شما اجازه دسترسی به این فایل را ندارید ... !\n🔐 لطفا شناسه فایل را صحیح بفرستید :", "markdown", $btn_back, $message_id);
    } else joinSend($from_id);
}
#  ------------------------------------------------------------
elseif ($step == "sendPassword") {
    if (isJoin($from_id)) {
        $id = $user['getFile'];
        $pass = urlencode($text);
        sendMessage($from_id, "✔️ با موفقیت فایل شما قفل شد ... !", "markdown", $btn_home, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none', `getFile` = '' WHERE `from_id` = '{$from_id}' LIMIT 1");
        $db->query("UPDATE `file` SET `password` = '$pass' WHERE `id` = '{$id}'");
    } else joinSend($from_id);
}
# Join ------------------------------------------------------------
elseif (preg_match('/^join_(.*)/', $data, $match)) {
    if (isJoin($from_id)) {
        deleteMessage($from_id, $message_id);
        $match[1];
        if ($match[1]) {
            send($from_id, null, $match[1], 'send');
        } else sendMessage($from_id, "👤 سلام `$first_name`\n🤖 به ربات آپلودک خوش امدید!\n\n🏷 اپلود رایگان و دائم فایل ها بدون هیچ محدودیت زمانی !\n\n🚦 شما میتوانید ( عکس , فیلم , گیف , استیکر و ... ) در ربات اپلود کنید همراه با نمایش تعداد دانلود های فایل شما ... !\n\n▪️ شما میتوانید تا سقف یک گیگابایت (2GB) فایل اپلود کنید و لینک فایل خودتون رو دریافت کنید و برای دوستان خود ارسال کنید :\n\n🔐 دقت کنید که میتوانید برای لینک فایل های خودتون رمز بگزارید تا هرکسی نتواند فایلتون رو دانلود کنه , برای دسترسی به فایل وقتی که کاربر با لینک دانلود وارد میشود ربات از او رمز رو درخواست میکند در صورت صحیح بودن رمزی که شما برای فایلتون انتخاب کردید فایل برایش ارسال میشود ... !\n\n📤 همین الان یه فایل بفرس تا آپلود بشه و لذتشو ببر !\n\n🤖 @$usernamebot", null);
    } else {
        answercallbackquery($callback_query_id, "❌ شما هنوز عضو کانال های ربات نیستید");
        $lockSQL = mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` != 'false'");
        $i = 0;
        while ($id = mysqli_fetch_assoc($lockSQL)) {
            $key = str_replace(['1', '2', '3', '4', '5', '6', '7', '8', '9', '0'], ['اول', 'دوم', 'سوم', 'چهارم', 'پنجم', 'ششم', 'هفتم', 'هشتم', 'نهم', 'دهم'], $i + 1);
            $chat = getChat($id['type_id']);
            $invite_link = $id['columnTwo'] ?: $chat->result->invite_link;
            if (Blacksource('getChatMember', ['chat_id' => $id['type_id'], 'user_id' => $from_id])->result->status == 'left') {
                $button[] = [['text' => "عضویت در کانال $key", 'url' => "$invite_link"]];
            } else $i--;
            $i++;
        }
        $button[] = [['text' => "عضو شدم | دانلود ✅", 'callback_data' => "join_" . $match[1]]];
        $buttons = json_encode(['inline_keyboard' => $button]);
        editMessageText($from_id, $message_id, "❓ برای استفاده از ربات و اپلود و دریافت فایل عضو کانال های ما شوید.\n\n💡 پس عضویت بر روی « عضو شدم » کلیک کنید", null, $buttons);
    }
}
# get File ------------------------------------------------------------
elseif (((preg_match('/^upload_(.*)/', $step, $match) or (isset($message->document) or isset($message->video) or isset($message->photo) or isset($message->sticker) or isset($message->audio) or isset($message->voice))) and $text != '🗄 اتمام اپلود') and !in_array($step, ['setAds', 'DeleteFile', 'addAdmin', 'addLock', 'forAll', 'sendAll'])) {
    if (isJoin($from_id)) {
        $id = $match[1] ?: random();
        $db->query("UPDATE `user` SET `step` = 'upload_$id' WHERE `from_id` = '{$from_id}' LIMIT 1");
        $captionSQL = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'caption'"));
        if ($captionSQL['columnTwo'] == 'allCaption') $caption = urldecode($captionSQL['columnOne']);
        else $caption = $message->caption ?: urldecode($captionSQL['columnOne']);
# Up file ------------------------------------------------------------
        if (isset($message->document)) {
            $file_id = $message->document->file_id;
            $file_size = $message->document->file_size;
            $size = convert($file_size);
            $time = date('h:i:s');
            $date = date('Y/m/d');
            Blacksource('senddocument', [
                'chat_id' => $chat_id,
                'document' => $file_id,
                'caption' => "📍 فایل شما با موفقیت داخل دیتابیس ذخیره شده ... !\n▪️ شناسه فایل شما : <code>$id</code>\n\n➖ بقیه اطلاعات فایل شما : \n\n💾  حجم فایل : <b>$size</b>\n📝 توضیحات فایل : \n<code>$caption</code>\nلینک اشتراک گذاری فایل:\n📥 https://t.me/" . $usernamebot . "?start=get_" . $id,
                'reply_to_message_id' => $message_id,
                'parse_mode' => "html"
            ]);
            $caption = urlencode($caption);
            $db->query("INSERT INTO `file` (`id`, `file_id`, `type`,`caption`, `password`, `file_size`, `user_id`, `date`, `time`) VALUES ('{$id}', '{$file_id}', 'document', '$caption', '', '{$file_size}', '{$from_id}', '{$date}', '{$time}')");
        }
# up videos  ------------------------------------------------------------
        elseif (isset($message->video)) {
            $file_id = $message->video->file_id;
            $file_size = $message->video->file_size;
            $size = convert($file_size);
            $time = date('h:i:s');
            $date = date('Y/m/d');
            Blacksource('sendvideo', [
                'chat_id' => $from_id,
                'video' => $file_id,
                'caption' => "📍 ویدیو شما با موفقیت داخل دیتابیس ذخیره شده ... !\n▪️ شناسه ویدیو شما : <code>$id</code>\n\n➖ بقیه اطلاعات ویدیو شما : \n\n💾  حجم ویدیو : <b>$size</b>\n📝 توضیحات ویدیو : \n<code>$caption</code>\nلینک اشتراک گذاری ویدیو:\n📥 https://t.me/" . $usernamebot . "?start=get_" . $id,
                'reply_to_message_id' => $message_id,
                'parse_mode' => "html"
            ]);
            $caption = urlencode($caption);
            $db->query("INSERT INTO `file` (`id`, `file_id`, `type`, `caption`, `password`, `file_size`, `user_id`, `date`, `time`) VALUES ('{$id}', '{$file_id}', 'video', '$caption', '', '{$file_size}', '{$from_id}', '{$date}', '{$time}')");
        }
# up photo ------------------------------------------------------------
        elseif (isset($message->photo)) {
            $file_id = $message->photo[0]->file_id;
            $file_size = $message->photo[0]->file_size;
            $size = convert($file_size);
            $time = date('h:i:s');
            $date = date('Y/m/d');
            Blacksource('sendphoto', [
                'chat_id' => $from_id,
                'photo' => $file_id,
                'caption' => "📍 عکس شما با موفقیت داخل دیتابیس ذخیره شده ... !\n▪️ شناسه عکس شما : <code>$id</code>\n\n➖ بقیه اطلاعات عکس شما : \n\n💾  حجم عکس : <b>$size</b>\n📝 توضیحات عکس : \n<code>$caption</code>\nلینک اشتراک گذاری عکس:\n📥 https://t.me/" . $usernamebot . "?start=get_" . $id,
                'reply_to_message_id' => $message_id,
                'parse_mode' => "html"
            ]);
            $caption = urlencode($caption);
            $db->query("INSERT INTO `file` (`id`, `file_id`, `type`, `caption`, `password`, `file_size`, `user_id`, `date`, `time`) VALUES ('{$id}', '{$file_id}', 'photo', '$caption', '', '{$file_size}', '{$from_id}', '{$date}', '{$time}')");
        }
# up voice ------------------------------------------------------------
        elseif (isset($message->voice)) {
            $file_id = $message->voice->file_id;
            $file_size = $message->voice->file_size;
            $size = convert($file_size);
            $time = date('h:i:s');
            $date = date('Y/m/d');
            Blacksource('sendvoice', [
                'chat_id' => $from_id,
                'voice' => $file_id,
                'caption' => "📍 ویس شما با موفقیت داخل دیتابیس ذخیره شده ... !\n▪️ شناسه ویس شما : <code>$id</code>\n\n➖ بقیه اطلاعات ویس شما : \n\n💾  حجم ویس : <b>$size</b>\n📝 توضیحات ویس : \n<code>$caption</code>\nلینک اشتراک گذاری ویس:\n📥 https://t.me/" . $usernamebot . "?start=get_" . $id,
                'reply_to_message_id' => $message_id,
                'parse_mode' => "html"
            ]);
            $caption = urlencode($caption);
            $db->query("INSERT INTO `file` (`id`, `file_id`, `type`, `caption`, `password`, `file_size`, `user_id`, `date`, `time`) VALUES ('{$id}', '{$file_id}', 'voice', '$caption', '', '{$file_size}', '{$from_id}', '{$date}', '{$time}')");
        }
# up Music   ------------------------------------------------------------
        elseif (isset($message->audio)) {
            $file_id = $message->audio->file_id;
            $file_size = $message->audio->file_size;
            $size = convert($file_size);
            $time = date('h:i:s');
            $date = date('Y/m/d');
            Blacksource('sendaudio', [
                'chat_id' => $from_id,
                'audio' => $file_id,
                'caption' => "📍 آهنگ شما با موفقیت داخل دیتابیس ذخیره شده ... !\n▪️ شناسه آهنگ شما : <code>$id</code>\n\n➖ بقیه اطلاعات آهنگ شما : \n\n💾  حجم آهنگ : <b>$size</b>\n📝 توضیحات آهنگ : \n<code>$caption</code>\nلینک اشتراک گذاری آهنگ:\n📥 https://t.me/" . $usernamebot . "?start=get_" . $id,
                'reply_to_message_id' => $message_id,
                'parse_mode' => "html"
            ]);
            $caption = urlencode($caption);
            $db->query("INSERT INTO `file` (`id`, `file_id`, `type`, `caption`, `password`, `file_size`, `user_id`, `date`, `time`) VALUES ('{$id}', '{$file_id}', 'audio', '$caption', '', '{$file_size}', '{$from_id}', '{$date}', '{$time}')");
        }
# up sticher ------------------------------------------------------------
        elseif (isset($message->sticker)) {
            $file_id = $message->sticker->file_id;
            $file_size = $message->sticker->file_size;
            $size = convert($file_size);
            $time = date('h:i:s');
            $date = date('Y/m/d');
            Blacksource('sendsticker', [
                'chat_id' => $from_id,
                'sticker' => $file_id,
                'reply_to_message_id' => $message_id,
                'parse_mode' => "html"
            ]);
            sendMessage($from_id, "📍 استیکر شما با موفقیت داخل دیتابیس ذخیره شده ... !\n▪️ شناسه استیکر شما : <code>$id</code>\n\n➖ بقیه اطلاعات استیکر شما : \n\n💾  حجم استیکر : <b>$size</b>\nلینک اشتراک گذاری استیکر:\n📥 https://t.me/" . $usernamebot . "?start=get_" . $id, "html", null, $message_id + 1);
            $db->query("INSERT INTO `file` (`id`, `file_id`, `type`, `password`, `file_size`, `user_id`, `date`, `time`) VALUES ('{$id}', '{$file_id}', 'sticker', '', '{$file_size}', '{$from_id}', '{$date}', '{$time}')");
        }
#  ------------------------------------------------------------
        $count = mysqli_num_rows(mysqli_query($db, "SELECT * FROM `file` WHERE `id` = '{$id}'"));
        sendMessage($from_id, "🗂 تعداد فایل های اپلود شده تا اینجا : $count\n▪️ لطفا اگر فایل دیگری دارید بفرستید :", "markdown", $btn_end, $message_id);
        $db->query("UPDATE `user` SET `step` = 'upload_$id' WHERE `from_id` = '{$from_id}' LIMIT 1");
    } else joinSend($from_id);
}
#  ------------------------------------------------------------
elseif ($text == '🗄 اتمام اپلود') {
    if (isJoin($from_id)) {
        if (preg_match('/^upload_(.*)/', $step, $match)) $id = $match[1];
        $count = mysqli_num_rows(mysqli_query($db, "SELECT * FROM `file` WHERE `id` = '{$id}'"));
        if ($count > 1) $fileCount = 'فایل های';
        else  $fileCount = 'فایل';
        sendMessage($from_id, "✅ $fileCount شما با موفقیت اپلود شد!\n\n📍 $fileCount شما با موفقیت داخل دیتابیس ذخیره شده ... !\n▪️ شناسه $fileCount شما : <code>$id</code>\n\n➖ شما : لینک اشتراک گذاری $fileCount:\n📥 https://t.me/" . $usernamebot . "?start=get_" . $id, "html", $btn_home, $message_id);
        sendMessage("@Link", "✅ تست\n[فیلم جدید](https://t.me/$usernamebot?start=get_$id) ", "markdown");
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '{$from_id}' LIMIT 1");
    } else joinSend($from_id);
    exit(false);
}
# Panel ------------------------------------------------------------
if ($from_id == $admin) {
# Panel ------------------------------------------------------------
    if ($text == '/panel' or $text == '👤 مدیریت') {
        sendMessage($admin, "👤 به منوی مدیریت ربات خود خوش امدید", "markdown", $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
    }
# Back ------------------------------------------------------------
    elseif ($text == 'برگشت 🔙') {
        sendMessage($admin, "▪️ به منوی مدیریت بازگشتید :", "markdown", $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
    }
# status ------------------------------------------------------------
    elseif ($text == '👤 امار ربات') {
        $users = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `user`")) ?: 0);
        $onlineUsers = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `user` WHERE `update_at` > $time - 60")) ?: 0);
        $hourlyUsers = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `user` WHERE `create_at` > $time - 3600")) ?: 0);
        $dailyUsers = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `user` WHERE `create_at` > $time - 86400")) ?: 0);
        $weeklyUsers = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `user` WHERE `create_at` > $time - 25200")) ?: 0);
        $monthlyUsers = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `user` WHERE `create_at` > $time - 2592000")) ?: 0);
        $inactives = number_format(mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `status` = 'inactive'")) ?: 0);
        $files = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `file`")) ?: 0);
        $admins = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'admin'")) ?: 0);
        $locks = number_format(mysqli_num_rows(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` != 'false'")) ?: 0);
        $timeA = date('h:i:s');
        $dateA = date('Y/m/d');
        sendMessage($from_id, "🤖 امار شما در ساعت `$time` و تاریخ `$date` به این صورت میباشد \n\n👥 تعداد اعضا : `$users`\n👀 تعداد کاربران آنلاین : `$onlineUsers`\n🕒 تعداد کاربران ساعت گذشته : `$hourlyUsers`\n☪️ تعداد کاربران 24 ساعت گذشته : `$dailyUsers`\n7️⃣ تعداد کاربران هفته گذشته : `$weeklyUsers`\n🌛 تعداد کاربران ماه گذشته : `$monthlyUsers`\n❗️ تعداد کاربران غیر فعال : `$inactives`\n🗂 تعداد فایل ها : `$files`\n👨🏻‍💻 تعداد ادمین ها : `$admins`\n📢 تعداد کانال ها : `$locks`", "markdown", $panel, $message_id);
    }
# send All ------------------------------------------------------------
    elseif ($text == '📪 ارسال به همه') {
        sendMessage($from_id, "▪️ لطفا پیام خود را ارسال کنید :\nمیتوانید در قالب html ارسال کنید", "markdown", $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'sendAll' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'sendAll') {
        $text = urlencode($text);
        sendMessage($from_id, "✔️ پیام شما با موفقیت برای ارسال همگانی تنظیم شد", "markdown", $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
        $db->query("DELETE FROM `send` WHERE 1");
        $db->query("INSERT INTO `send` (`step`, `text`, `from`, `user`) VALUES('send', '$text', '$admin', 0)");
    }
# For All ------------------------------------------------------------
    elseif ($text == '📪 فوروارد به همه') {
        sendMessage($from_id, "▪️ لطفا پیام خود را ارسال کنید :", "markdown", $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'forAll' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'forAll') {
        sendMessage($from_id, "✔️ پیام شما با موفقیت برای ارسال همگانی تنظیم شد", "markdown", $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
        $db->query("DELETE FROM `send` WHERE 1");
        $db->query("INSERT INTO `send` (`step`, `text`, `from`, `user`) VALUES('for', '$message_id', '$admin', 0)");
    }
# Add Lock ------------------------------------------------------------
    elseif (in_array($text, ['🔒 بخش قفل ها'])) {
        $lockSQL = $db->query("SELECT * FROM `settings` WHERE `type` = 'lock'");
        if (mysqli_num_rows($lockSQL) > 0) {
            $lockText = "☑️ به بخش (🔒 بخش قفل ها) خوش امدید\n\n🚦 راهنما :\n1 - 👁 برای مشاهده ی هر کدام روی اسم ان بزنید.\n2 - برای حذف هر کدام روی دکمه ی ( 🗑 ) بزنید\n3 - 🔗 برای تعییر لینک روی دکمه ی ( ⚙️ ) بزنید \n4 - برای افزودن قفل روی دکمه ی ( 🔐 افزودن قفل ) بزنید";
            $button[] = [['text' => '🗝 نام قفل', 'callback_data' => 'show_lock'], ['text' => '🗑 حذف', 'callback_data' => 'show_del'], ['text' => '⚙️ تغییر لینک', 'callback_data' => 'show_change']];
            while ($row = mysqli_fetch_assoc($lockSQL)) {
                $lock = getChat($row['type_id'])->result;
                $name = $lock->title;
                $link = $row['columnTwo'] ?: $lock->invite_link;
                if (!$link) {
                    $name = 'دسترسی ندارد';
                    $link = 'https://t.me/username';
                }
                $button[] = [['text' => "🔑 $name", 'url' => "$link"], ['text' => '🗑', 'callback_data' => "remove_lock_{$row['type_id']}"], ['text' => '⚙️', 'callback_data' => "change_lock_{$row['type_id']}"]];
            }
        } else $lockText = '❌ شما قفلی برای حذف و مشاهده ندارید لطفا از طریق دکمه ی ( 🔐 افزودن قفل ) اضافه کنید.';
        $button[] = [['text' => '🔐 افزودن قفل', 'callback_data' => 'addLock'], ['text' => '(🔙) برگشت', 'callback_data' => 'panel']];
        sendMessage($from_id, $lockText, null, json_encode(['inline_keyboard' => $button]), $message_id);
    }
#  ------------------------------------------------------------
    elseif ($data == 'addLock') {
        sendMessage($from_id, "☑️ لطفا ربات را ادمین ( حتما تیک افزودن عضو باز باشد ) و  یک پیام از کانالی که میخواهید به قفل های ربات اضافه کنید فوروارد کنید.\n\n⁉️ : برای افزودن گروه هم ربات را همانطور که گفته شده ادمین کنید سپس ایدی عددی گروه ( @groupinfobot ) را ارسال کنید", null, $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'addLock' WHERE `from_id` = '$from_id'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'addLock') {
        if (($forward_from_chat_id and $forward_from_chat_type == 'channel') or $text) {
            if ($text and !preg_match('/-(.*)/', $text)) $text = '-' . $text;
            $id = $forward_from_chat_id ?: $text;
            $lock = getChat($id)->result;
            $link = $lock->invite_link;
            $name = $lock->title;
            if ($link) {
                if (mysqli_num_rows(mysqli_query($db, "SELECT * FROM `settings` WHERE `type_id` = '$id'")) == 0) {
                    $db->query("INSERT INTO `settings`(`type`, `type_id`, `columnOne`) VALUES ('lock', '$id', 'true')");
                    sendMessage($from_id, "✅ قفل با موفقیت اضافه شد. \n\n📃 مشخصات:\n🆔 ایدی عددی قفل : {$id}\n🔗 لینک : {$link}\n📣 نام : {$name}\n\n❌ اگر میخواهید لینک قفل شده را تغییر دهید لطفا لینک جدید را همینجا ارسال کنید و اگر میخواهید همین لینک باقی بماند دکمه ی برگشت را بزنید", null, $back_panel, $message_id);
                    $owner = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'admin' AND `columnOne` = 'main'"))['type_id'];
                    if ($admin_data['columnOne'] != 'main') sendMessage($owner, "✅ قفل با موفقیت اضافه شد. \n\n📃 مشخصات:\n🆔 ایدی عددی قفل : {$id}\n🔗 لینک : {$link}\n📣 نام : {$name}\n🧑🏻‍💻 توسط ادمین : $first_name");
                } else sendMessage($from_id, "❌ قفل زیر از قبل اضافع شده\n🔗 لینک : {$link}", null, $panel, $message_id);
                $db->query("UPDATE `user` SET `step` = 'change_lock_{$id}' WHERE `from_id` = '$from_id'");
            } else sendMessage($from_id, "❌ .در این کانال یا گروه ادمین نیست و یا دسترسی های لازم را ندارد\nلطفا بعد از ادمین کردن ربات در کانال یا گروه مورد نظر پیامی از همان قفل فروارد کنید یا ایدی عددی ان را ارسال کنید.", null, $back_panel, $message_id);
        } else sendMessage($from_id, "❌ شما تنها میتوانید ایدی عددی گروه یا کانال را ارسال و یا یک پیام از کانال فوروارد کنید", null, $back_panel, $message_id);
    }
# Delete Lock ------------------------------------------------------------
    elseif (preg_match('/^remove_lock_(.*)/', $data, $match)) {
        answercallbackquery($callback_query_id, "✅ با موفقیت حذف شد");
        $db->query("DELETE FROM `settings` WHERE `type` = 'lock' AND `type_id` = '{$match[1]}'");
        $lockSQL = $db->query("SELECT * FROM `settings` WHERE `type` = 'lock'");
        if (mysqli_num_rows($lockSQL) > 0) {
            $locksText = "☑️ به بخش (🔒 بخش قفل ها) خوش امدید\n\n🚦 راهنما :\n1 - 👁 برای مشاهده ی هر کدام روی اسم ان بزنید.\n2 - برای حذف هر کدام روی دکمه ی ( 🗑 ) بزنید\n3 - 🔗 برای تعییر لینک روی دکمه ی ( ⚙️ ) بزنید \n4 - برای افزودن قفل روی دکمه ی ( 🔐 افزودن قفل ) بزنید";
            $button[] = [['text' => '🗝 نام قفل', 'callback_data' => 'show_lock'], ['text' => '🗑 حذف', 'callback_data' => 'show_del'], ['text' => '⚙️ تغییر لینک', 'callback_data' => 'show_change']];
            while ($row = mysqli_fetch_assoc($lockSQL)) {
                $lock = getChat($row['type_id'])->result;
                $name = $lock->title;
                $link = $row['columnTwo'] ?: $lock->invite_link;
                if (!$link) {
                    $name = 'دسترسی ندارد';
                    $link = 'https://t.me/username';
                }
                $button[] = [['text' => "🔑 $name", 'url' => "$link"], ['text' => '🗑', 'callback_data' => "remove_lock_{$row['type_id']}"], ['text' => '⚙️', 'callback_data' => "change_lock_{$row['type_id']}"]];
            }
        } else $locksText = '❌ شما قفلی برای حذف و مشاهده ندارید لطفا از طریق دکمه ی ( 🔐 افزودن قفل ) اضافه کنید.';
        $button[] = [['text' => '🔐 افزودن قفل', 'callback_data' => 'addLock'], ['text' => '(🔙) برگشت', 'callback_data' => 'panel']];
        editMessageText($from_id, $message_id, $locksText, null, json_encode(['inline_keyboard' => $button]));
        $owner = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'admin' AND `columnOne` = 'main'"))['type_id'];
        if ($admin_data['columnOne'] != 'main') sendMessage($owner, "❌ قفل با موفقیت حذف شد. \n\n📃 مشخصات:\n🆔 ایدی عددی قفل : {$id}\n🔗 لینک : {$link}\n📣 نام : {$name}\n🧑🏻‍💻 توسط ادمین : $first_name");
    }
#  ------------------------------------------------------------
    elseif (preg_match('/^change_lock_(.*)/', $data, $match)) {
        $lockD = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` = '{$match[1]}'"));
        $lock = getChat($match[1])->result;
        $name = $lock->title;
        $link = $lockD['columnTwo'] ?: $lock->invite_link;
        sendMessage($from_id, "☑️ برای تنظیم لینک جدید برای این قفل ( $name ) لطفا لینک جدید را ارسال کنید\n🔗 لینک فعلی : $link\n\n⚠️ توجه داشته باشید که باید با <code>https://t.me/</code> شروع شود", 'html', $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'change_lock_{$match[1]}' WHERE `from_id` = '$from_id'");
    }
#  ------------------------------------------------------------
    elseif (preg_match('/^change_lock_(.*)/', $step, $match)) {
        if (preg_match('/^[https:\/\/t.me\/|http:\/\/t.me\/](.*)/', $text)) {
            sendMessage($from_id, "✅ با موفقیت لینک جایگزین شد .", null, $panel, $message_id);
            $db->query("UPDATE `settings` SET `columnTwo` = '{$text}' WHERE `type` = 'lock' AND `type_id` = '{$match[1]}'");
            $db->query("UPDATE `user` SET `step` = 'change_lock_{$match[1]}' WHERE `from_id` = '$from_id'");
        } else sendMessage($from_id, "⚠️ توجه داشته باشید که باید با <code>https://t.me/</code> شروع شود\nلطفا دوباره ارسال کنید", null, $back_panel, $message_id);
    }
# Add A'dmin ------------------------------------------------------------
    elseif (in_array($text, ['🧑🏻‍💻 بخش ادمین ها'])) {
        if ($from_id == $admin) {
            $adminsSQL = mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'admin' AND `columnOne` != 'main'");
            if (mysqli_num_rows($adminsSQL) > 0) {
                $adminsText = "☑️ به بخش (🧑🏻‍💻 بخش ادمین ها) خوش امدید\n\n🚦 راهنما :\n1 - 👁 برای مشاهده ی هر کدام روی اسم ان ادمین بزنید.\n2 - برای حذف هر کدام روی دکمه ی ( 🗑 ) بزنید\n3 - برای افزودن ادمین روی دکمه ی ( ➕ افزودن ادمین ) بزنید";
                $button[] = [['text' => '🧑🏻‍💻 نام ادمین', 'callback_data' => 'show_admin'], ['text' => '🗑 حذف', 'callback_data' => 'show_admin']];
                while ($row = mysqli_fetch_assoc($adminsSQL)) {
                    $name = getChat($row['type_id'])->result->first_name;
                    if (!$name) $name = 'یافت نشد';
                    $button[] = [['text' => "🧑🏻‍💻 $name", 'url' => "tg://openmessage?user_id={$row['type_id']}"], ['text' => '🗑', 'callback_data' => "remove_ad_{$row['type_id']}"]];
                }
            } else $adminsText = '❌ شما ادمینی برای حذف و مشاهده ندارید لطفا از طریق دکمه ی ( ➕ افزودن ادمین ) اضافه کنید.';
            $button[] = [['text' => '➕ افزودن ادمین', 'callback_data' => 'addAdmin'], ['text' => 'برگشت (🔙)', 'callback_data' => 'panel']];
            sendMessage($from_id, $adminsText, null, json_encode(['inline_keyboard' => $button]), $message_id);
        } else sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $back_panel, $message_id);
    }
#  ------------------------------------------------------------
    elseif ($data == 'addAdmin') {
        sendMessage($from_id, "☑️ لطفا ایدی عددی کاربر را وارد کنید.", null, $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'addAdmin' WHERE `from_id` = '$from_id'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'addAdmin') {
        $userP = mysqli_fetch_assoc($db->query("SELECT * FROM `user` WHERE `from_id` = '$text'"));
        if ($userP) {
            $name = getChat($userP['from_id'])->result->first_name;
            if (mysqli_num_rows(mysqli_query($db, "SELECT * FROM `settings` WHERE `type_id` = '{$userP['from_id']}' AND `type` = 'admin'")) == 0) {
                sendMessage($from_id, "✅ با موفقیت به ادمین ها اضافه شد.\n\n👤 نام کاربر : $name\n🆔 ایدی عددی کاربر : {$userP['from_id']}", null, $panel, $message_id);
                sendMessage($userP['from_id'], "✅ شما با موفقیت به ادمین های ربات اضافه شدید لطفا ربات رو استارت کنید.\n/start");
                $db->query("INSERT INTO `settings` (`type`, `type_id`, `columnOne`) VALUES ('admin', '$text', 'admin')");
                $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
            } else sendMessage($from_id, "❌ کاربر از قبل ادمین ربات است. لطفا ایدی دیگری بفرستید", null, $back_panel, $message_id);
        } else sendMessage($from_id, "❌ کاربر ربات را استارت نکرده است. لطفا ایدی دیگری بفرستید", null, $back_panel, $message_id);
    }
#  -----------------------------------------------------------
    elseif (preg_match('/^remove_ad_(.*)/', $data, $match)) {
        answercallbackquery($callback_query_id, "✅ با موفقیت حذف شد");
        sendMessage($match[1], "❌ شما از لیست ادمین ها حذف شدید لطفا استارت کنید\n/start");
        $db->query("DELETE FROM `settings` WHERE `type` = 'admin' AND `type_id` = '{$match[1]}'");
        $adminsSQL = $db->query("SELECT * FROM `settings` WHERE `type` = 'admin' AND `columnOne` != 'main'");
        if (mysqli_num_rows($adminsSQL) > 0) {
            $adminsText = "☑️ به بخش (🧑🏻‍💻 بخش ادمین ها) خوش امدید\n\n🚦 راهنما :\n1 - 👁 برای مشاهده ی هر کدام روی اسم ان ادمین بزنید.\n2 - برای حذف هر کدام روی دکمه ی ( 🗑 ) بزنید\n3 - برای افزودن ادمین روی دکمه ی ( ➕ افزودن ادمین ) بزنید";
            $button[] = [['text' => '🧑🏻‍💻 نام ادمین', 'callback_data' => 'show_admin'], ['text' => '🗑 حذف', 'callback_data' => 'show_admin']];
            while ($row = mysqli_fetch_assoc($adminsSQL)) {
                $name = getChat($row['type_id'])->result->first_name;
                if (!$name) $name = 'یافت نشد';
                $button[] = [['text' => "🧑🏻‍💻 $name", 'url' => "tg://openmessage?user_id={$row['type_id']}"], ['text' => '🗑', 'callback_data' => "remove_ad_{$row['type_id']}"]];
            }
        } else $adminsText = '❌ شما ادمینی برای حذف و مشاهده ندارید لطفا از طریق دکمه ی ( ➕ افزودن ادمین ) اضافه کنید.';
        $button[] = [['text' => '➕ افزودن ادمین', 'callback_data' => 'addAdmin'], ['text' => 'برگشت (🔙)', 'callback_data' => 'panel']];
        editMessageText($from_id, $message_id, $adminsText, null, json_encode(['inline_keyboard' => $button]));
    }
# Delete File ------------------------------------------------------------
    elseif ($text == '🗑 تنظیم حذف شدن') {
        $buttons = [[['text' =>  'برگشت 🔙'], ['text' => '0']]];
        for ($i = 1; $i < 97; $i++) {
            $pi = $i + 6;
            for ($i; $i < $pi; $i++) {
                $button[] = ['text' => "$i"];
            }
            $buttons[] = $button;
            $button = [];
            $i--;
        }
        $buttons = json_encode(['keyboard' => $buttons]);
        sendMessage($from_id, "▪️ لطفا یک عدد را برای مدت زمان حذف شدن فایل وارد کنید .\nاز کیبورد زیر هم میتوانید کمک بگیرید.\n\nℹ️ همچنین برای حذف مدت زمان میتوانید بر روی دکمه ی 0 کلیک یا تایپ کنید.\n\n⚠️ توجه داشته باشید که به دقیقه حساب میشود", "markdown", $buttons, $message_id);
        $db->query("UPDATE `user` SET `step` = 'DeleteFile' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'DeleteFile') {
        sendMessage($from_id, "✔️ مدت زمان با موفقیت تنظیم شد", null, $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
        $db->query("UPDATE `settings` SET `type_id` = '$text' WHERE `type` = 'del'");
    }
# set Ads ------------------------------------------------------------
    elseif ($text == '📣 تنظیم تبلیغ') {
        $ads = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'ads'"));
        if ($ads['type_id'])
            if ($ads['type_id'] != 'text') Blacksource("send{$ads['type_id']}", ['chat_id' => $from_id, $ads['type_id'] => $ads['columnOne'], 'caption' => urldecode($ads['columnTwo']), 'parse_mode' => "html"]);
            else sendMessage($from_id, urldecode($ads['columnTwo']), 'html');
        else sendMessage($from_id, "`تبلیغی ثبت نشده است ...`", 'markdown');
        sendMessage($from_id, "👆🏻 تبلیغ قبلی \n\n▪️ لطفا تبلیغ خود را ارسال کنید :\nمیتوانید در قالب html ارسال کنید\n\nدر تایپ های : \nعکس . فیلم . گیف . ویس . آهنگ . متن ساده", null, $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'setAds' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'setAds') {
        $caption = $text ?: $message->caption;
        if (isset($message->document)) {
            $type =  'document';
            $file_id = $message->document->file_id;
        } elseif (isset($message->video)) {
            $type =  'video';
            $file_id = $message->video->file_id;
        } elseif (isset($message->photo)) {
            $type =  'photo';
            $file_id = $message->photo[0]->file_id;
        } elseif (isset($message->voice)) {
            $type =  'voice';
            $file_id = $message->voice->file_id;
        } elseif (isset($message->audio)) {
            $type =  'audio';
            $file_id = $message->audio->file_id;
        } elseif (isset($message->sticker)) {
            $type =  'sticker';
            $file_id = $message->sticker->file_id;
        } elseif (isset($message->text)) {
            $type = 'text';
        } else {
            $type = 'none';
            $file_id = '';
        }
        if ($type != 'none') {
            if (!$text) Blacksource("send{$type}", ['chat_id' => $from_id, "$type" => $file_id, 'caption' => $caption, 'parse_mode' => "html"]);
            else sendMessage($from_id, $text, 'html');
            sendMessage($from_id, "✔️ تبلیغ شما با موفقیت برای ارسال تبلیغ تنظیم شد\n( ❌ پیام قبلی تبلیغ شما است که اگر ارسال نشد یعنی تبلیغ شما بدرستی تنظیم نشده است )", null, $panel, $message_id);
            $caption = urlencode($caption);
            $db->query("DELETE FROM `settings` WHERE `type` = 'ads'");
            $db->query("INSERT INTO `settings`(`type`, `type_id`, `columnOne`, `columnTwo`) VALUES('ads', '$type', '$file_id', '$caption')");
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
        } else sendMessage($from_id, "❌ شما فقط میتوانید پیام با تایپ های زیر را ارسال کنید : \nفایل . ویدیو . عکس . ویس . اهنگ . استیکر . متن\n\nلطفا دوباره ارسال کنید", null, $back_panel, $message_id);
    }
# Delete Ads ------------------------------------------------------------
    elseif ($text == '🗑 حذف تبلیغ') {
        $ads = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'ads'"));
        if ($ads['type_id']) {
            if ($ads['type_id'] != 'text') Blacksource("send{$ads['type_id']}", ['chat_id' => $from_id, $ads['type_id'] => $ads['columnOne'], 'caption' => urldecode($ads['columnTwo']), 'parse_mode' => "html"]);
            else sendMessage($from_id, urldecode($ads['columnTwo']), 'html');
            sendMessage($from_id, "👆🏻 تبلیغ قبلی \n\nتبلیغ با موفقیت حذف شد", null, $panel, $message_id);
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
            $db->query("DELETE FROM `settings` WHERE `type` = 'ads'");
        } else sendMessage($from_id, "`تبلیغی ثبت نشده است ...`", 'markdown');
    }
# set caption ------------------------------------------------------------
    elseif ($text == '📝 تنظیم کپشن') {
        $btn = json_encode(['inline_keyboard' => [
            [['text' => '📍 همه ی اپلود شده ها', 'callback_data' => 'set_allCaption']],
            [['text' => '📍 اپلود شده های بدون کپشن', 'callback_data' => 'set_noCaption']]
        ]]);
        $caption = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'caption'"));
        if ($caption['type_id']) sendMessage($from_id, "{$caption['columnOne']}", 'html', $btn);
        else sendMessage($from_id, "`کپشنی ثبت نشده است ...`", 'markdown');
        sendMessage($from_id, "👆🏻 کپشن قبلی \n\n▪️ لطفا کپشن خود را ارسال کنید :\n( تنها متن میتوانید ارسال کنید ; متن میتواند در قالب html نیز باشد )", null, $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'setCaption' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($data == 'set_allCaption') {
        editMessageText($from_id, $message_id, "✅ با موفقیت روی همه ی پست های ارسالی این کپشن تنظیم میشود");
        $db->query("UPDATE `settings` SET `columnTwo` = 'allCaption' WHERE `type` = 'caption'");
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($data == 'set_noCaption') {
        editMessageText($from_id, $message_id, "✅ با موفقیت روی پست هایی که کپشن ندارند این کپشن تنظیم میشود");
        $db->query("UPDATE `settings` SET `columnTwo` = 'allCaption' WHERE `type` = 'caption'");
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'setCaption') {
        $text = urlencode($text);
        $btn = json_encode(['inline_keyboard' => [
            [['text' => '📍 همه ی اپلود شده ها', 'callback_data' => 'set_allCaption']],
            [['text' => '📍 اپلود شده های بدون کپشن', 'callback_data' => 'set_noCaption']]
        ]]);
        sendMessage($from_id, "✔️ کپشن شما با موفقیت تنظیم شد ایا میخواهید این کپشن برای تمامی فایل های اپلود شده اعمال شود یا فایل های اپلود شده ی بدون کپشن ؟\n( به صورت پیشفرض روی پست هایی که کپشن ندارند ست میشود )", "markdown", $btn, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
        $db->query("INSERT INTO `settings`(`type`, `type_id`, `columnOne`, `columnTwo`) VALUES('caption', '', '$text', 'noCaption')");
    }
# D'elete caption  ------------------------------------------------------------
    elseif ($text == '🗑 حذف کپشن') {
        $caption = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'caption'"));
        if ($caption['columnOne']) {
            sendMessage($from_id, "{$caption['columnOne']}", 'html');
            sendMessage($from_id, "👆🏻 کپشن قبلی \n\کپشن با موفقیت حذف شد", null, $panel, $message_id);
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
            $db->query("DELETE FROM `settings` WHERE `type` = 'caption'");
        } else sendMessage($from_id, "`کپشن ثبت نشده است ...`", 'markdown');
    }
# set Seen channel ------------------------------------------------------------
    elseif ($text == '👁‍🗨 تنظیم کانال سین') {
        $seenChannel = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'seenChannel'"));
        if ($caption['type_id']) sendMessage($from_id, "{$caption['columnOne']}", 'html', $btn);
        else sendMessage($from_id, "`لینکی ثبت نشده است ...`", 'markdown');
        sendMessage($from_id, "👆🏻 لینک قبلی \n\n▪️ لطفا لینک خود را ارسال کنید :\n( تنها لینک دارای <code>https://t.me</code> یا @ میتوانید ارسال کنید )", 'html', $back_panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'linkSeen' WHERE `from_id` = '$admin'");
    }
#  ------------------------------------------------------------
    elseif ($step == 'linkSeen') {
        if (preg_match('/^[https:\/\/t.me\/|http:\/\/t.me\/|@](.*)/', $text)) {
            sendMessage($from_id, "✅ لینک با موفقیت روی کانال سین تنظیم شد", null, null, $message_id);
            $db->query("DELETE FROM `settings` WHERE `type` = 'linkSeen'");
            $db->query("INSERT INTO `settings` (`type`, `type_id`, `columnOne`, `columnTwo`) VALUES('linkSeen', '', '$text', '');");
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
        } else sendMessage($from_id, "⚠️ توجه داشته باشید که باید با <code>https://t.me/</code> و یا با @ شروع شود\nلطفا دوباره ارسال کنید", null, $back_panel, $message_id);
    }
# D'elete Seen channel ------------------------------------------------------------
    elseif ($text == '🗑 حذف کانال سین') {
        $linkSeen = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'linkSeen'"));
        if ($linkSeen['columnOne']) {
            sendMessage($from_id, "{$linkSeen['columnOne']}", 'html');
            sendMessage($from_id, "👆🏻 لینک قبلی \n\لینک با موفقیت حذف شد", null, $panel, $message_id);
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$admin'");
            $db->query("DELETE FROM `settings` WHERE `type` = 'linkSeen'");
        } else sendMessage($from_id, "`لینکی ثبت نشده است ...`", 'markdown');
    }
}
